<?php
namespace app\admin\controller;
use think\facade\Db;
use think\facade\View;
use think\facade\Cookie;

class Demo extends AdminBase
{
    public function _config(){
        $this->modules    = 'house_floor';
        $this->pk         = 'house_floor_id';
        $this->base_where = [];
        $this->order      = 'house_floor_sort DESC';
        $this->top_btn = "<button class=\"layui-btn layui-btn-sm\" onclick=\"dialog('/admin2022.php/".request()->controller()."/add.html', '添加')\">添加</button>";

        $this->search = [
            "house_floor_name" => 'input|名称',
        ];
        // if(input('get.other__daterange_clue_addtime')){
        //     $temp = explode(' - ', input('get.other__daterange_clue_addtime'));
        //     $stime = strtotime($temp[0].' 00:00:00');
        //     $etime = strtotime($temp[1].' 23:59:59');
        //     $this->base_where[] = ['clue_addtime', 'between', [$stime, $etime]];
        // }
        $this->column = [
            ['field'=>'house_floor_id','width'=>90,'title'=>'ID'],
            ['field'=>'house_floor_name','title'=>'名称'],
            ['field'=>'house_floor_sort','title'=>'排序'],
            ['field'=>'sys_action','align'=>'left','width'=>150,'fixed'=>'right','title'=>'操作']
        ];

        $this->add_form = [
            ['type'=>'text','title'=>'名称','field'=>'house_floor_name'],
            ['type'=>'text','title'=>'排序','field'=>'house_floor_sort'],
        ];
        $this->tpl_dir = 'base';
    }

    public function listsFormat($rows)
    {
        foreach ($rows as $k => $v) {
            $rows[$k]['sys_action']   = $this->_operate($v);
        }
        return $rows;
    }

    public function _operate($row)
    {
        $html  = '';
        $html .= "<a class=\"layui-btn layui-btn-warm layui-btn-xs\" onclick=\"dialog('/admin2022.php/".request()->controller()."/edit.html?house_floor_id={$row['house_floor_id']}', '编辑')\">编辑</a>";
        $html .= "<a class=\"layui-btn layui-btn-danger layui-btn-xs\" lay-event=\"del\">删除</a>";
        return $html;
    }
}
?>