/*
Navicat MySQL Data Transfer

Source Server         : 127.0.0.1
Source Server Version : 50726
Source Host           : 127.0.0.1:3306
Source Database       : 51la

Target Server Type    : MYSQL
Target Server Version : 50726
File Encoding         : 65001

Date: 2024-09-25 17:34:09
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for ai_admin
-- ----------------------------
DROP TABLE IF EXISTS `ai_admin`;
CREATE TABLE `ai_admin` (
  `admin_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `admin_pid` int(11) NOT NULL,
  `admin_group_id` int(11) NOT NULL,
  `admin_name` varchar(20) NOT NULL COMMENT 'text-真实姓名',
  `admin_type` tinyint(4) NOT NULL COMMENT '1广东 2莫斯科 3圣彼得堡 4集散地',
  `admin_account` varchar(10) NOT NULL COMMENT 'text-账号',
  `admin_pwd` varchar(64) NOT NULL,
  `admin_addtime` bigint(20) NOT NULL COMMENT '添加时间',
  `admin_state` int(1) NOT NULL,
  `admin_logintime` bigint(20) NOT NULL,
  `admin_sort` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `city_id` int(11) NOT NULL,
  PRIMARY KEY (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统：后台管理员';

-- ----------------------------
-- Records of ai_admin
-- ----------------------------
INSERT INTO `ai_admin` VALUES ('1', '0', '1', 'Admin', '0', 'admin', 'aaffebecec560fec66e75f24062224ffa4e07696d2ae9a1fee3707c3f8fd9373', '1663921729', '1', '1650956137', '0', '0', '0');

-- ----------------------------
-- Table structure for ai_admin_group
-- ----------------------------
DROP TABLE IF EXISTS `ai_admin_group`;
CREATE TABLE `ai_admin_group` (
  `admin_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_group_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `admin_group_location` text COLLATE utf8_unicode_ci NOT NULL COMMENT '位置',
  `admin_group_phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL COMMENT '电话',
  `admin_group_auth` longtext COLLATE utf8_unicode_ci NOT NULL,
  `admin_group_addtime` bigint(20) NOT NULL,
  `admin_group_sort` int(11) NOT NULL,
  PRIMARY KEY (`admin_group_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='系统：管理员组';

-- ----------------------------
-- Records of ai_admin_group
-- ----------------------------
INSERT INTO `ai_admin_group` VALUES ('1', '超级管理员', '', '', '', '1715309953', '0');

-- ----------------------------
-- Table structure for ai_admin_log
-- ----------------------------
DROP TABLE IF EXISTS `ai_admin_log`;
CREATE TABLE `ai_admin_log` (
  `admin_log_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_log_username` varchar(255) NOT NULL,
  `admin_log_link` varchar(255) NOT NULL,
  `admin_log_addtime` bigint(20) NOT NULL,
  `admin_log_sort` int(11) NOT NULL,
  PRIMARY KEY (`admin_log_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统：管理员日志';

-- ----------------------------
-- Records of ai_admin_log
-- ----------------------------

-- ----------------------------
-- Table structure for ai_banner
-- ----------------------------
DROP TABLE IF EXISTS `ai_banner`;
CREATE TABLE `ai_banner` (
  `banner_id` int(11) NOT NULL AUTO_INCREMENT,
  `banner_name` varchar(255) NOT NULL,
  `banner_picture` varchar(255) NOT NULL COMMENT '图',
  `banner_url` varchar(255) NOT NULL,
  `banner_location` varchar(255) NOT NULL COMMENT '位置',
  `banner_sort` int(11) NOT NULL,
  `banner_addtime` bigint(20) NOT NULL,
  PRIMARY KEY (`banner_id`) USING BTREE,
  KEY `banner_addtime` (`banner_addtime`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统：轮播图';

-- ----------------------------
-- Records of ai_banner
-- ----------------------------
INSERT INTO `ai_banner` VALUES ('7', '01', '20240516/9a1cd4e1cad85b9302cb1e52589dc805.png', '', 'index-top', '30', '1715841589');
INSERT INTO `ai_banner` VALUES ('8', '02', '20240516/9a1cd4e1cad85b9302cb1e52589dc805.png', '', 'index-top', '20', '1710832941');
INSERT INTO `ai_banner` VALUES ('9', '03', '20240516/9a1cd4e1cad85b9302cb1e52589dc805.png', '', 'index-top', '10', '1710832945');

-- ----------------------------
-- Table structure for ai_category
-- ----------------------------
DROP TABLE IF EXISTS `ai_category`;
CREATE TABLE `ai_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_pid` int(11) NOT NULL DEFAULT '0',
  `category_name` varchar(90) NOT NULL COMMENT '名称',
  `category_icon` varchar(240) NOT NULL COMMENT '图标',
  `category_is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示',
  `category_is_single` tinyint(1) NOT NULL COMMENT '是否是单页 1是 2否',
  `category_info` text NOT NULL COMMENT '单页介绍',
  `category_addtime` bigint(20) NOT NULL,
  `category_sort` int(11) NOT NULL,
  PRIMARY KEY (`category_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='分类';

-- ----------------------------
-- Records of ai_category
-- ----------------------------
INSERT INTO `ai_category` VALUES ('1', '0', '水果', '', '1', '0', '', '1723311890', '0');
INSERT INTO `ai_category` VALUES ('2', '1', '苹果', '', '1', '0', '', '1723311890', '0');
INSERT INTO `ai_category` VALUES ('3', '1', '西瓜', '', '1', '0', '', '1723311890', '0');
INSERT INTO `ai_category` VALUES ('4', '1', '香蕉', '', '1', '0', '', '1723311890', '0');
INSERT INTO `ai_category` VALUES ('5', '0', '蔬菜', '', '1', '0', '', '1723311890', '0');
INSERT INTO `ai_category` VALUES ('6', '5', '青菜', '', '1', '0', '', '1723311890', '0');
INSERT INTO `ai_category` VALUES ('7', '5', '花菜', '', '1', '0', '', '1723311890', '0');
INSERT INTO `ai_category` VALUES ('8', '5', '茄子', '', '1', '0', '', '1723311890', '0');

-- ----------------------------
-- Table structure for ai_config
-- ----------------------------
DROP TABLE IF EXISTS `ai_config`;
CREATE TABLE `ai_config` (
  `config_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `config_key` char(60) NOT NULL COMMENT '键',
  `config_title` varchar(240) NOT NULL COMMENT '标题',
  `config_type` varchar(120) NOT NULL COMMENT '类型',
  `config_value` longtext NOT NULL COMMENT '参数',
  `config_remark` text NOT NULL COMMENT '备注',
  `config_field_type` varchar(240) NOT NULL COMMENT '表单类型',
  `config_sort` int(11) NOT NULL COMMENT '排序',
  PRIMARY KEY (`config_id`) USING BTREE,
  UNIQUE KEY `config_key` (`config_key`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统：配置';

-- ----------------------------
-- Records of ai_config
-- ----------------------------
INSERT INTO `ai_config` VALUES ('1', 'mp_share_title', '分享标题', '全局', '请在后台上设置', '', 'text', '0');
INSERT INTO `ai_config` VALUES ('2', 'mp_share_image', '小程序分享主图', '全局', 'share-image.jpg', '500像素-400像素', 'image', '0');
INSERT INTO `ai_config` VALUES ('3', 'wechat_mp_appid', '小程序APPID', '全局', '', '', 'text', '0');
INSERT INTO `ai_config` VALUES ('4', 'wechat_pay_key', '微信商户号Key', '全局', '', '', 'text', '0');
INSERT INTO `ai_config` VALUES ('5', 'wechat_pay_mch_id', '微信商户号', '全局', '', '', 'text', '0');
