$(function(){
    $('.layui-nav-item').removeClass('layui-nav-itemed')
    $('.layui-nav-child dd').each(function(index, dom){
        if($(dom).hasClass('layui-this')){
            $(dom).parents('.layui-nav-item').addClass('layui-nav-itemed')
        }
    })
})

function dialog(url, title, area = false){
    let cache = 0
    if(!area){
        area = [`80%`, `80%`];
    } else {
        if(area[0].indexOf('px')){
            cache = parseInt( area[0].replace(/px/g, '') );
            if(cache > $(window).width()){ area[0] = '90%'; }
        }
        if(area[1].indexOf('px')){
            cache = parseInt( area[1].replace(/px/g, '') );
            if(cache > $(window).height()){ area[1] = '90%'; }
        }
    }
    layer.open({
        type: 2,
        title: title,
        shadeClose: false,
        shade: 0.8,
        area: area,
        content: url
    });
}

// 弹出层内使用：window.parent.preview_img(this)
function preview_img(obj) {
    var windowHeight = window.screen.height;
    var imgBigH = windowHeight / 1.35;

    var img = new Image();
    img.src = obj.src;
    var height = img.height;
    var width = img.width;
    var scaleWH = width / height;

    var bigH = height;
    var bigW = width;
    if (bigH > imgBigH) {
        bigH = imgBigH;
        bigW = scaleWH * bigH;
        if (bigW > 1000) {
            bigW = 1000;
            bigH = bigW / scaleWH;
        }
    }
    var imgHtml = "<img src='" + obj.src + "' width='"+bigW+"px' height='"+bigH+"px'/>";
    layer.open({
        type: 1,
        shade: 0.8,
        offset: 'auto',
        area: [bigW + 'px',bigH+'px'],
        shadeClose: true,
        closeBtn:0,
        scrollbar: false,
        title: false,
        content: imgHtml,
        cancel: function () {
            //layer.msg('捕获就是从页面已经存在的元素上，包裹layer的结构', { time: 5000, icon: 6 }); 
        }
    });
}