import App from './App'
import store from './store';
import {
    hyRequest
} from "./service/index.js"
import {
    baseURL
} from './service/config.js'

import ElementUI from 'element-ui';
import 'element-ui/lib/theme-chalk/index.css';

Vue.use(ElementUI);
Vue.prototype.__API__ = baseURL
Vue.prototype.$hyRequest = hyRequest
Vue.prototype.$store = store

Vue.prototype.toNav = (url) => {
    uni.navigateTo({
        url: url,
        animationType: 'pop-in',
        animationDuration: 200
    })
}
Vue.prototype.toTab = (url) => {
    uni.switchTab({
        url: url
    });
}

Vue.prototype.toRedirect = (url) => {
    uni.redirectTo({
        url: url
    });
}

Vue.prototype.toNavBack = (delta = 1) => {
    uni.navigateBack({
        delta: delta
    })
}
Vue.prototype.open = (url) => {
    window.open(url, '_blank');
}

Vue.prototype.formatTime = (timestamp, fmtString = "YY-MM-DD") => {
    // 1.将时间戳转成Date
    const date = new Date(timestamp)
    // 2.正则和值匹配起来
    const dateO = {
        "Y+": date.getFullYear(),
        "M+": date.getMonth() + 1,
        "D+": date.getDate(),
        "h+": date.getHours(),
        "m+": date.getMinutes(),
        "s+": date.getSeconds()
    }
    // 3.for循环进行替换
    for (const key in dateO) {
        const keyRe = new RegExp(key)
        if (keyRe.test(fmtString)) {
            const value = (dateO[key] + "").padStart(2, "0")
            fmtString = fmtString.replace(keyRe, value)
        }
    }
    return fmtString
}
Vue.prototype.copy = (str) => {
    uni.setClipboardData({
        data: `${str}`,
        success: function() {
            console.log('success');
        }
    });
}
Vue.prototype.$add_rpx = (obj) => {
    for (let key in obj) {
        if (obj.hasOwnProperty(key)) {
            const newKey = key;
            if (typeof obj[key] === 'object' && obj[key] !== null) {
                // 如果是对象且不是null，则递归调用
                Vue.prototype.$add_rpx(obj[key], newKey);
            } else {
                // 否则打印当前键值对
                const arr = ['paddingLeft', 'paddingRight', 'paddingTop', 'paddingBottom', 'marginLeft',
                    'marginRight', 'marginTop', 'marginBottom', 'height', 'borderRadius', 'borderTopLeftRadius',
                    'borderTopRightRadius', 'borderBottomLeftRadius', 'borderBottomRightRadius', 'top', 'left',
                    'width', 'fontSize', 'lineHeight', 'letterSpacing'
                ]
                const arr2 = ['borderWidth']
                const arr3 = ['textIndent']
                if (arr.indexOf(newKey) !== -1) {
                    obj[key] = obj[key] + 'rpx'
                }
                if (arr2.indexOf(newKey) !== -1) {
                    obj[key] = obj[key] + 'px'
                }
                if (arr3.indexOf(newKey) !== -1) {
                    obj[key] = obj[key] + 'em'
                }
            }
        }
    }
}
Vue.prototype.$addStyle = (customStyle, target = 'object') => {
    // 字符串转字符串，对象转对象情形，直接返回
    if (empty(customStyle) || typeof(customStyle) === 'object' && target === 'object' || target === 'string' &&
        typeof(customStyle) === 'string') {
        return customStyle
    }
    // 字符串转对象
    if (target === 'object') {
        // 去除字符串样式中的两端空格(中间的空格不能去掉，比如padding: 20px 0如果去掉了就错了)，空格是无用的
        customStyle = trim(customStyle)
        // 根据";"将字符串转为数组形式
        const styleArray = customStyle.split(';')
        const style = {}
        // 历遍数组，拼接成对象
        for (let i = 0; i < styleArray.length; i++) {
            // 'font-size:20px;color:red;'，如此最后字符串有";"的话，会导致styleArray最后一个元素为空字符串，这里需要过滤
            if (styleArray[i]) {
                const item = styleArray[i].split(':')
                style[trim(item[0])] = trim(item[1])
            }
        }
        return style
    }
    // 这里为对象转字符串形式
    let string = ''
    for (const i in customStyle) {
        // 驼峰转为中划线的形式，否则css内联样式，无法识别驼峰样式属性名
        const key = i.replace(/([A-Z])/g, '-$1').toLowerCase()
        string += `${key}:${customStyle[i]};`
    }
    // 去除两端空格
    return trim(string)
}

// #ifndef VUE3
import Vue from 'vue'
import './uni.promisify.adaptor'
Vue.config.productionTip = false
App.mpType = 'app'
const app = new Vue({
  ...App
})
app.$mount()
// #endif

// #ifdef VUE3
import { createSSRApp } from 'vue'
export function createApp() {
  const app = createSSRApp(App)
  return {
    app
  }
}
// #endif