// 封装成类 -> 实例
import {
    baseURL
} from "./config.js"



class HYRequest {
    constructor(baseURL) {
        this.baseURL = baseURL
    }
    async request(options, tier) {     
        const {
            url
        } = options
        
        if (typeof options.data == 'undefined') {
            options.data = {}
        }
        if (uni.getStorageSync('admin_id')) {
            options.data.admin_id = uni.getStorageSync('admin_id')
        }
        if (uni.getStorageSync('admin_hash')) {
            options.data.admin_hash = uni.getStorageSync('admin_hash')
        }

        return new Promise((resolve, reject) => {
            uni.request({
                ...options,
                url: this.baseURL + url,
                header: {
                    'content-type': 'application/json'
                },
                success: (res) => {
                    // 前端传入了admin_id，但后端库中没有找到（后台删除了）
                    if(res.data.status === -98) {
                        uni.removeStorageSync('admin_id')
                        uni.removeStorageSync('admin_hash')
                        uni.reLaunch({
                            url: '/pages/admin/login'
                        })
                    }
                    // 新用户进来，没有传入admin_id
                    if(res.data.status === -99) {
                        uni.navigateTo({
                            url: '/pages/admin/login'
                        })
                    }
                    if(tier === 2 && res.data.status == 1) {
                        resolve(res.data.data) 
                    } else {
                        resolve(res.data)
                    }
                    
                },
                fail: (err) => {
                    
                }
            })
        })
    }
    
    get(options, tier = 2) {
        return this.request({
            ...options,
            method: "get"
        }, tier)
    }
    post(options, tier = 2) {
        return this.request({
            ...options,
            method: "post"
        }, tier)
    }
}

export const hyRequest = new HYRequest(baseURL)
// export const hyRequest = new HYRequest("http://d.qishan.com")