import Vue from 'vue'
import {
    hyRequest
} from "@/service/index.js"

export default {
    namespaced: true,
    // 调用页面
    // this.$store.state.index.config
    state: {
        config: ""
    },
    mutations: {
        config_get(state, res) {
            state.config = res
        }
    },
    actions: {
        // 调用页面引入
        // import {
        //     mapActions
        // } from 'vuex';
        // ...mapActions({
        //     get_config_list: "index/get_config_list",
        // }),
        get_config_list(context, e) {
            return new Promise((resolve, reject) => {
                hyRequest.post({
                    url: "/index/config",
                }).then(res => {
                    let data = JSON.parse(JSON.stringify(res))
                    context.commit('config_get', data)
                    resolve()
                })
            })
        },
    }
}