import App from './App'
import uView from '@/uni_modules/uview-ui'
import store from './store'
Vue.use(uView)

import {hyRequest} from "./service/index.js"
import {baseURL} from './service/config.js'

Vue.prototype.__API__ = baseURL
Vue.prototype.$store = store
Vue.prototype.$hyRequest = hyRequest

Vue.prototype.tips = (msg) => {
    uni.showToast({
        title: msg,
        duration: 2000,
        icon: 'none',
        mask: true
    });
}
Vue.prototype.toNav = (url) => {
    uni.navigateTo({
        url: url,
        animationType: 'pop-in',
        animationDuration: 200
    })
}
Vue.prototype.toTab = (url) => {
    uni.switchTab({
        url: url
    });
}

Vue.prototype.toRedirect = (url) => {
    uni.redirectTo({
        url: url
    });
}

Vue.prototype.toNavBack = (delta = 1) => {
    const pages = getCurrentPages()
    if (pages.length > 1) {
        uni.navigateBack({
            delta: delta
        })
    } else {
        uni.reLaunch({
            url: '/pages/index/index'
        })
    }
}

Vue.prototype.is_login = () => {
    if (uni.getStorageSync('__UID__')) {
        return true
    } else {
        return false
    }
}
Vue.prototype.call = (phone) => {
    uni.makePhoneCall({
        phoneNumber: phone,
        success:(res) => {},
        fail:(res) => {},
        complete:(res) => {},
    });
}
Vue.prototype.formatTime = (timestamp, fmtString = "YY-MM-DD") => {
    // 1.将时间戳转成Date
    const date = new Date(timestamp)
    // 2.正则和值匹配起来
    const dateO = {
        "Y+": date.getFullYear(),
        "M+": date.getMonth() + 1,
        "D+": date.getDate(),
        "h+": date.getHours(),
        "m+": date.getMinutes(),
        "s+": date.getSeconds()
    }
    // 3.for循环进行替换
    for (const key in dateO) {
        const keyRe = new RegExp(key)
        if (keyRe.test(fmtString)) {
            const value = (dateO[key] + "").padStart(2, "0")
            fmtString = fmtString.replace(keyRe, value)
        }
    }
    return fmtString
}
Vue.prototype.copy = (str) => {
    uni.setClipboardData({
        data: `${str}`,
        success: function() {
            console.log('success');
        }
    });
}
// #ifndef VUE3
import Vue from 'vue'
import './uni.promisify.adaptor'
Vue.config.productionTip = false
App.mpType = 'app'
const app = new Vue({
    store,
    ...App
})
app.$mount()
// #endif

// #ifdef VUE3
import {
    createSSRApp
} from 'vue'
export function createApp() {
    const app = createSSRApp(App)
    return {
        app
    }
}
// #endif