// 封装成类 -> 实例
import {
    baseURL
} from "./config.js"



class HYRequest {
    constructor(baseURL) {
        this.baseURL = baseURL
    }
    async request(options, tier) {     
        const {
            url
        } = options
        
        if (typeof options.data == 'undefined') {
            options.data = {}
        }
        if (uni.getStorageSync('user_id')) {
            options.data.user_id = uni.getStorageSync('user_id')
        }
        if (uni.getStorageSync('user_hash')) {
            options.data.user_hash = uni.getStorageSync('user_hash')
        }

        return new Promise((resolve, reject) => {
            uni.request({
                ...options,
                url: this.baseURL + url,
                header: {
                    'content-type': 'application/json'
                },
                success: (res) => {
                    // 前端传入了user_id，但后端库中没有找到（后台删除了）
                    if(res.data.status === -98) {
                        uni.removeStorageSync('user_id')
                        uni.removeStorageSync('user_hash')
                        uni.reLaunch({
                            url: '/pages/index/index'
                        })
                    }
                    // 新用户进来，没有传入user_id
                    if(res.data.status === -99) {
                        uni.navigateTo({
                            url: '/pages/index/login'
                        })
                    }
                    if(tier === 2 && res.data.status == 1) {
                        resolve(res.data.data) 
                    } else {
                        resolve(res.data)
                    }
                    
                },
                fail: (err) => {
                    
                }
            })
        })
    }
    
    get(options, tier = 2) {
        return this.request({
            ...options,
            method: "get"
        }, tier)
    }
    post(options, tier = 2) {
        return this.request({
            ...options,
            method: "post"
        }, tier)
    }
}

export const hyRequest = new HYRequest(baseURL)
// export const hyRequest = new HYRequest("http://d.qishan.com")